<?php
class Noticias_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('noticias_model');
    }

    // Función para obtener la noticia basado en el ID
    public function obtenerNoticia($idnoticia)
    {
        $this->db->select('*')->from('noticias')->where('id =', $idnoticia);

        $noticia = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $noticia,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
        
        
    }


    // Función para actualizar la noticia
    public function actualizarNoticia($noticia)
    {   
        //Iniciando la transacción
        $this->db->trans_begin();
        $this->load->library('upload');
        
        $id       = $noticia["id"];
        $archivo      = $noticia["archivo"];
        $descripcion    = $noticia["descripcion"];
        $fecha2    = $noticia["fecha2"];
        $titulo   = $noticia["titulo"];

        if(file_exists($_SERVER['DOCUMENT_ROOT'].'/archivos/'.substr($noticia['archivo'],39))){
            unlink($_SERVER['DOCUMENT_ROOT'].'/archivos/'.substr($noticia['archivo'],39));
        }
        
        $ruta = $_SERVER['DOCUMENT_ROOT'].'/archivos/';
            if(array_key_exists('documento', $_FILES)){
                if (!is_dir($ruta)) {
                    mkdir($ruta, 0777, true);
                }
                $mi_archivo = 'documento';
                $config['upload_path'] = $_SERVER['DOCUMENT_ROOT'].'/archivos/';
                $config['allowed_types'] = 'png|jpeg|gif|jpg';
                $config['encrypt_name'] = true;
                $config['max_size'] = '51200';
    
                $this->upload->initialize($config);
    
                if (!$this->upload->do_upload($mi_archivo)) {
                    //*** ocurrio un error
                    $data['uploadError'] = $this->upload->display_errors();
                    echo $this->upload->display_errors();
                    return;
                }else{
                $titulo   = $noticia['titulo'];

                // Creando el array con los datos básicos del usuario
                $noticia = array(
                    'archivo'    => 'https://noticias2124.nld.gob.mx/archivos/'.$this->upload->data('file_name'),
                    'titulo' => $titulo
                );
                
                     // Actualizando la tabla de usuarios
                    $this->db->set($noticia);
                    $this->db->where('id', $id);
                    $this->db->update('noticias');
                }
                
                $data['uploadSuccess'] = $this->upload->data();
        }else{
            $this->db->set($noticia);
            $this->db->where('id', $id);
            $this->db->update('noticias');
        }

        
       

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al actualizar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'respuesta' => 'Noticia actualizada correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    public function agregarNoticia($datos)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
        
        $this->db->limit(1);
        $this->db->order_by('id', 'DESC');
        $this->db->select('*')->from('noticias');
        $orden = $this->db->get()->row_array();
            /////////FIRMA/////////////////
            $ruta = $_SERVER['DOCUMENT_ROOT'].'/archivos/';
            if(array_key_exists('documento', $_FILES)){
                if (!is_dir($ruta)) {
                    mkdir($ruta, 0777, true);
                }
                $mi_archivo = 'documento';
                $config['upload_path'] = $_SERVER['DOCUMENT_ROOT'].'/archivos/';
                $config['allowed_types'] = 'png|jpeg|gif|jpg';
                $config['encrypt_name'] = true;
                $config['max_size'] = '51200';
    
                $this->upload->initialize($config);
    
                if (!$this->upload->do_upload($mi_archivo)) {
                    //*** ocurrio un error
                    $data['uploadError'] = $this->upload->display_errors();
                    echo $this->upload->display_errors();
                    return;
                }else{
                // print_r($datos);
                // $id       = $dato["id"];
                // $orden    = $datos['orden'];
                $titulo   = $datos['titulo'];
                $descripcion   = $datos['descripcion'];
                $tipo = 'noticias';
                $fecha2 = $datos['fecha2'];


                // Creando el array con los datos básicos del usuario
                $noticia = array(
                    'archivo'    => 'https://noticias2124.nld.gob.mx/archivos/'.$this->upload->data('file_name'),
                    'titulo' => $titulo,
                    'descripcion' => $descripcion,
                    'tipo' => $tipo,
                    'fecha2' => $fecha2,
                    'fecha' => date('d-m-Y H:i:s')
                );
                
                    $this->db->set($noticia);
                    $this->db->insert('noticias2');
                }
                
                $data['uploadSuccess'] = $this->upload->data();
        }
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    // Función para eliminar la imagen
    public function eliminarNoticia($mas)
    {   
        // Iniciando la transacción
        $this->db->trans_begin();
        
        $id = $mas["id"];
        $archivo = $mas["archivo"];
    
        // Extraer el nombre del archivo desde la URL
        $filename = basename($archivo);
        $filepath = $_SERVER['DOCUMENT_ROOT'].'/archivos/'.$filename;
    
        // Eliminando el archivo si existe
        if(file_exists($filepath)){
            if (!unlink($filepath)) {
                $respuesta = array(
                    'respuesta' => 'Error al eliminar el archivo.',
                    'status' => REST_Controller::HTTP_INTERNAL_SERVER_ERROR
                );
                return $respuesta;
            }
        } else {
            $respuesta = array(
                'respuesta' => 'El archivo no existe.',
                'status' => REST_Controller::HTTP_NOT_FOUND
            );
            return $respuesta;
        }
    
        // Eliminando la noticia de la base de datos
        $this->db->where('id', $id);
        $this->db->delete('noticias2');
    
        // Si la transacción presenta errores
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'respuesta' => 'Ocurrió un error al eliminar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
            return $respuesta;
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'respuesta' => 'Noticia eliminada correctamente',
                'status' => REST_Controller::HTTP_OK
            );
            return $respuesta;
        }
    }
    
    
    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'noticias');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
}