<?php
class Usuarios_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('usuarios_model');
    }

    // Función para obtener la lista de tipos de usuarios
    public function obtenerTiposDeUsuario()
    {
        $this->db
        ->select('*')
        ->from('roles')
        ->where('rol  != ', 'ciudadano');

        $tiposDeUsuario= $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $tiposDeUsuario,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    // Función para obtener el tipo de usuario basado en el ID
    public function obtenerTipoDeUsuario($idUsuario)
    {
        $this->db
        ->select('tipo')
        ->from('usuarios')
        ->where('idusuario = ', $idUsuario);
        
        $tipoDeUsuario =  $this->db->get()->row_array()["tipo"];

        $respuesta = array(
            'respuesta' => $tipoDeUsuario,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    // Función para obtener la lista de usuarios activos
    public function obtenerUsuarios()
    {
        $this->db
        ->select('*')
        ->from('usuarios')
        ->where('activo = ', 1);

        $usuarios = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $usuarios,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    // Función para obtener el usuario basado en el ID
    public function obtenerUsuario($idUsuario)
    {
        $idRol = $this->obtenerTipoDeUsuario($idUsuario);

        $this->db
             ->select('roles.rol, usuarios.tipo, nombre, correo, usuarios.activo')
             ->from('usuarios')
             ->join('roles', 'usuarios.tipo = roles.idrol')
             ->where('idusuario =', $idUsuario);

        $usuario = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $usuario,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
        
        
    }

    // Función para saber si ya existe el correo
    public function existeCorreo($correo, $nuevo, $idUsuario)
    {
        $correo_actual = "";

        if (!$nuevo) {
            $correo_actual = $this->db->get_where('usuarios', array('idusuario' => $idUsuario), 1)->row()->correo;
        }

        $query = $this->db->get_where('usuarios', array('correo' => $correo), 1);

        if($query->num_rows() > 0 )
        {
            if ($correo == $correo_actual) {
                $informacion = array(
                    'mensaje' => 'Correo disponible',
                    'registrado' => false,
                    'result' => $query->result(),
                    'status' => 200,
                );

                $respuesta = array(
                    'respuesta' => $informacion,
                    'status' => REST_Controller::HTTP_OK
                );
        
                return $respuesta;

            } else {
                $informacion = array(
                    'mensaje' => 'El correo ya existe',
                    'registros' => $query->row(),
                    'registrado' => true,
                    'status' => 200,
                );

                $respuesta = array(
                    'respuesta' => $informacion,
                    'status' => REST_Controller::HTTP_OK
                );
        
                return $respuesta;
            }
        }

        else
        {
            $informacion = array(
                'mensaje' => 'Correo disponible',
                'registros' => '',
                'registrado' => false,
                'status' => 200,
            );

            $respuesta = array(
                'respuesta' => $informacion,
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    // Función para guardar el usuario
    public function guardarUsuario($usuario)
    {
            $tipoDeUsuario = $usuario["idrol"];
            $nombre =  $usuario["nombre"];
            $correo = $usuario["correo"];
            $contrasena = $usuario["contrasena"];
            $activo = $usuario["activo"];

            // Encriptando la contraseña si no esta vacia
            if(!empty($contrasena))
            {
                //$contrasena = md5($contrasena);
                $contrasena = password_hash($contrasena, PASSWORD_BCRYPT);
            }
            
            // Comenzando la transacción
            $this->db->trans_begin();

            // Creando el array con los datos del usuario
            $usuario = array(
                'nombre' => $nombre,
                'correo' => $correo,
                'activo' => $activo,
                'password' => $contrasena,
                'tipo' => $tipoDeUsuario
            );

            // Guardando el usuario
            $this->db  
            ->insert('usuarios', $usuario);

            // Si ocurrio un error en la transacción
            if ($this->db->trans_status() === false) 
            {
                $respuesta = array(
                    'respuesta' => 'Ocurrio un error al guardar los datos',
                    'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
                );
        
                return $respuesta;
            } 
            
            // De lo contrario
            else 
            {
                $this->db->trans_commit();

                $respuesta = array(
                    'respuesta' => 'Usuario agregado correctamente',
                    'status' => REST_Controller::HTTP_OK
                );
        
                return $respuesta;

            }
    }

    // Función para actualizar el usuario
    public function actualizarUsuario($usuario)
    {
        $idUsuario = $usuario["id_usuario"];
        $nombre = $usuario["nombre"];
        $correo = $usuario["correo"];
        $activo = $usuario["activo"];
        $contrasena = $usuario["contrasena"];
        $idRol = $usuario["idrol"];

        // Creando el array con los datos básicos del usuario
        $usuario = array(
            'nombre' => $nombre,
            'correo' => $correo,
            'activo' => $activo,
            'tipo' => $idRol
        );

        // Encriptando la contraseña si no esta vacia
        if(!empty($contrasena))
        {
            $usuario["password"] = password_hash($contrasena, PASSWORD_BCRYPT);
        }

        //Iniciando la transacción
        $this->db->trans_begin();

        // Actualizando la tabla de usuarios
        $this->db->set($usuario);
        $this->db->where('idusuario', $idUsuario);
        $this->db->update('usuarios');

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al actualizar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'respuesta' => 'Usuario actualizado correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    public function cambiarEstado($idUsuario)
    {
        $this->db->trans_begin();
        
        $this->db
        ->set('activo', 'NOT activo', FALSE)
        ->where('idusuario', $idUsuario)
        ->update('usuarios');

        if($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();

            $respuesta = "Ocurrio un error, vuelva a intentar.";
            $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
        }

        else
        {
            $this->db->trans_commit();   

            $respuesta = "Estado actualizado correctamente";
            $status = REST_Controller::HTTP_OK;
        }    

        return array(
            'respuesta' =>  $respuesta,
            'status' => $status
        );
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'usuarios');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
}
 