<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Banners extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('banners_model');
    }

    // Obtener el paginador
    public function bannerspag_post()
    {
        $this->load->model('banners_model');
        $respuesta = $this->banners_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar el banner
     public function actualizar_banner_post()
     {
        $post = (array) json_decode($this->post('form'));
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->banners_model->actualizarBanner($post);
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para obtener la lista de los tipos de usuarios
    public function banner_get($idbanner = 0)
    {
        // Devolviendo los usuarios con un codigo 200 HTTP_OK
        $respuesta = $this->banners_model->obtenerBanner($idbanner);
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para actualizar
    public function cambiar_orden_post()
    {
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->banners_model->cambiar_orden($this->post());

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

    // Función para eliminar
    public function eliminar_banner_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->banners_model->eliminarBanner($post);

       $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para agregar el banner
    public function index_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->banners_model->agregarBanner($post);

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

}